<div <?php echo e($attributes->class(["row location-picker"])); ?>>
    <div class="col-md-4">
        <div class="form-group">
            <label for="country"><?php echo app('translator')->get("app.country"); ?> <span class="text-danger">*</span></label>
            <select id="country" name="country_id" class="form-control select2" data-placeholder="<?php echo app('translator')->get('app.select-country'); ?>">
                <?php if($selectedCountry): ?>
                    <option value="<?php echo e($selectedCountry->id); ?>" selected><?php echo e($selectedCountry->name); ?></option>
                <?php endif; ?>
            </select>
        </div>
    </div>

    <div class="col-md-4">
        <div class="form-group">
            <label for="state"><?php echo app('translator')->get("app.state"); ?> <span class="text-danger">*</span></label>
            <select id="state" name="state_id" class="form-control select2" data-placeholder="<?php echo app('translator')->get('app.select-state'); ?>">
                <?php if($selectedState): ?>
                    <option value="<?php echo e($selectedState->id); ?>" selected><?php echo e($selectedState->name); ?></option>
                <?php endif; ?>
            </select>
        </div>
    </div>

    <div class="col-md-4">
        <div class="form-group">
            <label for="city"><?php echo app('translator')->get("app.city"); ?> <span class="text-danger">*</span></label>
            <select id="city" name="city_id" class="form-control select2" data-placeholder="<?php echo app('translator')->get('app.select-city'); ?>">
                <?php if($selectedCity): ?>
                    <option value="<?php echo e($selectedCity->id); ?>" selected><?php echo e($selectedCity->name); ?></option>
                <?php endif; ?>
            </select>
        </div>
    </div>
</div>
<?php if (! $__env->hasRenderedOnce('2b55e7c9-b750-4a6c-8845-a090f8ee3813')): $__env->markAsRenderedOnce('2b55e7c9-b750-4a6c-8845-a090f8ee3813'); ?>
<?php $__env->startPush('style'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        width: '100%',
        allowClear: true
    });

    // Initialize country select2 with AJAX
    $('#country').select2({
        width: '100%',
        allowClear: true,
        ajax: {
            url: '<?php echo e(route('location.countries')); ?>',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    search: params.term,
                    page: params.page || 1
                };
            },
            processResults: function(data) {
                return {
                    results: data.data.map(country => ({
                        id: country.id,
                        text: country.name
                    })),
                    pagination: {
                        more: data.next_page_url ? true : false
                    }
                };
            },
            cache: true
        },
        placeholder: 'Select Country'
    });

    // Handle country change
    $('#country').on('change', function() {
        const countryId = $(this).val();
        $('#state').val(null).trigger('change');
        $('#city').val(null).trigger('change');

        if (countryId) {
            initializeStateSelect(countryId);
        }
    });

    // Handle state change
    $('#state').on('change', function() {
        const stateId = $(this).val();
        $('#city').val(null).trigger('change');

        if (stateId) {
            initializeCitySelect(stateId);
        }
    });

    function initializeStateSelect(countryId) {
        $('#state').select2({
            width: '100%',
            allowClear: true,
            ajax: {
                url: `<?php echo e(route('location.states')); ?>`,
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search: params.term,
                        country_id: countryId,
                        page: params.page || 1
                    };
                },
                processResults: function(data) {
                    return {
                        results: data.data.map(state => ({
                            id: state.id,
                            text: state.name
                        })),
                        pagination: {
                            more: data.next_page_url ? true : false
                        }
                    };
                },
                cache: true
            },
            placeholder: 'Select State'
        });
    }

    function initializeCitySelect(stateId) {
        $('#city').select2({
            width: '100%',
            allowClear: true,
            ajax: {
                url: `<?php echo e(route('location.cities')); ?>`,
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search: params.term,
                        state_id: stateId,
                        page: params.page || 1
                    };
                },
                processResults: function(data) {
                    return {
                        results: data.data.map(city => ({
                            id: city.id,
                            text: city.name
                        })),
                        pagination: {
                            more: data.next_page_url ? true : false
                        }
                    };
                },
                cache: true
            },
            placeholder: 'Select City'
        });
    }

    // Initialize state select2 if country is pre-selected
    <?php if($selectedCountry): ?>
        initializeStateSelect(<?php echo e($selectedCountry->id); ?>);
    <?php endif; ?>

    // Initialize city select2 if state is pre-selected
    <?php if($selectedState): ?>
        initializeCitySelect(<?php echo e($selectedState->id); ?>);
    <?php endif; ?>
});
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/components/location-picker.blade.php ENDPATH**/ ?>